/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.redstonefeatures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneUtils;

public class PointedRedstoneFeature<P>
extends Feature<PointedRedstoneConfiguration> {
    public PointedRedstoneFeature(Codec<PointedRedstoneConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<PointedRedstoneConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        PointedRedstoneConfiguration redstoneConfiguration = (PointedRedstoneConfiguration)context.m_159778_();
        Optional<Direction> optional = PointedRedstoneFeature.getTipDirection((LevelAccessor)level, pos, random);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = pos.m_121945_(optional.get().m_122424_());
        PointedRedstoneFeature.createPatchOfRedstoneBlocks((LevelAccessor)level, random, blockpos1, redstoneConfiguration);
        int i = random.m_188501_() < redstoneConfiguration.chanceOfTallerRedstone && PointedRedstoneUtils.isEmptyOrWater(level.m_8055_(pos.m_121945_(optional.get()))) ? 2 : 1;
        PointedRedstoneUtils.growPointedRedstone((LevelAccessor)level, pos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor level, BlockPos pos, RandomSource random) {
        boolean flag = PointedRedstoneUtils.isRedstoneBase(level.m_8055_(pos.m_7494_()));
        boolean flag1 = PointedRedstoneUtils.isRedstoneBase(level.m_8055_(pos.m_7495_()));
        if (flag && flag1) {
            return Optional.of(random.m_188499_() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfRedstoneBlocks(LevelAccessor level, RandomSource random, BlockPos pos, PointedRedstoneConfiguration redstoneConfiguration) {
        PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (random.m_188501_() > redstoneConfiguration.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = pos.m_121945_(direction);
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos);
            if (random.m_188501_() > redstoneConfiguration.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.m_121945_(Direction.m_235672_((RandomSource)random));
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos1);
            if (random.m_188501_() > redstoneConfiguration.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.m_121945_(Direction.m_235672_((RandomSource)random));
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos2);
        }
    }
}

